

// Initialize the variables and parameters of the model etc.

// Define the number of periods you would like to simulate the IRFs (TIRF), and the number of periods, after which you believe the constraint will no longer be non-binding (TShadowI)

@#define TshadowI = 20
@#define TIRF = 20
@#define TSimul = 500
@#define TDrop = 100
@#define TMoments = 500 



// Declaration of endogenous variable
Var 

// Endogeneous variables
cphat, 
cihat,
cehat,
lambdaphat,
lambdaihat,
lambdaehat,
psiehat,
muihat,
muehat,
rhat,
nphat,
nihat,
wphat,
wihat,
hphat,
hihat,
hehat,
qhat,
qkhat,
rkhat,
rhhat,
khat,
ihat,
yhat,
bphat,
bihat,
behat,
ctot,
ntot,

// Endogenous variables with exogenous dynamics
shatI,
shatE,
ahat,
epsilonhat;

Varexo
// Declaration of exogeneous variables (shocks)

epsilon_eshat,
epsilon_eahat,
epsilon_epshat;

@#for index in 0:( TshadowI - 1 )
	varexo epsilon_shadowImp_@{index};
	var shadow_sumImp_@{index};
@#endfor
@#define index = 10000000000

@#for index in 0:( TshadowI - 1 )
	varexo epsilon_shadowEnt_@{index};
    var shadow_sumEnt_@{index};
@#endfor
@#define index = 10000000000


parameters
// utility-function parameters

betaP,
betaI,
betaE, 
epsilonP,
epsilonI, 
nuP,
nuI,
sigmacP,
sigmahP,
sigmanP,
sigmacI,
sigmahI,
sigmanI,
sigmacE,

// Technology and related parameters

nI,
nE,
n,
sbarI,
sbarE,
alpha,
gamma,
phi,
delta,
omega,
rhoP,
rhoI,
rhoE,
varthetaI,
varthetaE,
xiI,
xiE,
rhos,
rhoa,
rho_eps,
sigma_ea,
sigma_es,
sigma_eps,

// Steady-state values

Ass, 
Hss,
Rss,
QKss,
Yss,
CPss,
CIss,
HIss,
HEss,
NPss,
NIss,
lambdaPss,
WPss,
HPss,
Qss,
lambdaIss,
muIss,
WIss,
Kss,
Iss,
CEss,
lambdaEss,
muEss, 
psiEss,
rKss, 
rHss,
BIss,
BEss,
BPss,
Ctotss,
Ntotss;
